# Installation
Hope this works soooonn

Install guide: https://www.talos.dev/v1.9/talos-guides/install/virtualized-platforms/proxmox/

## Create VM
Lav VM i GUI og herefter tilføj cpu args.
Gør det både for en control plane og en worker
```sh
export VM_ID=144
echo 'args: -cpu kvm64,+cx16,+lahf_lm,+popcnt,+sse3,+ssse3,+sse4.1,+sse4.2' >> /etc/pve/qemu-server/$VM_ID.conf
qm start $VM_ID
```
## Install Talos
Lav config og apply det
### Control Plane
```sh
export CONTROL_PLANE_IP=192.168.0.180
# Create
talosctl gen config talos-proxmox-cluster https://$CONTROL_PLANE_IP:6443 --output-dir _out --install-image factory.talos.dev/installer/ce4c980550dd2ab1b17bbf2b08801c7eb59418eafe8f279833297925d67c7515:v1.9.5 
# Apply
talosctl apply-config --insecure --nodes $CONTROL_PLANE_IP --file _out/controlplane.yaml
```

### Worker node
```sh
export WORKER_IP=192.168.0.139

# Apply
talosctl apply-config --insecure --nodes $WORKER_IP --file _out/worker.yaml
```

# Usage
For at snakke med controlplane, add det sådan her:
```sh
export TALOSCONFIG="_out/talosconfig"
talosctl config endpoint $CONTROL_PLANE_IP
talosctl config node $CONTROL_PLANE_IP
```

Jeg er i tvivl hvor vidt man så skal køre en "Bootstrap Etcd" efterfølgende, det står i "Using the Cluster
```sh
talosctl bootstrap


# Stuff

# MetalLB:
```sh
kubectl apply -f https://raw.githubusercontent.com/metallb/metallb/v0.13.10/config/manifests/metallb-native.yaml
# check pods:
kubectl get pods -n metallb-system
```

Lav en yaml fil med config til den, fx metallb-config.yaml
```yaml
# metallb-config.yaml
apiVersion: metallb.io/v1beta1
kind: IPAddressPool
metadata:
  namespace: metallb-system
  name: my-pool
spec:
  addresses:
    - 192.168.1.240-192.168.1.250
---
apiVersion: metallb.io/v1beta1
kind: L2Advertisement
metadata:
  namespace: metallb-system
  name: l2
spec: {}
```
```sh
kubectl apply -f metallb-config.yaml
```
