# with lvm utilize entire disk:

```bash
sudo pvcreate /dev/sdb
sudo vgcreate fast-vg /dev/sdb
sudo lvcreate -l 100%FREE -n fast-lv fast-vg
sudo mkfs.ext4 /dev/fast-vg/fast-lv
sudo mkdir -p /mnt/log/fast
echo '/dev/fast-vg/fast-lv /mnt/log/fast ext4 defaults 0 2' | sudo tee -a /etc/fstab
sudo mount /mnt/log/fast
```
and

```bash
sudo pvcreate /dev/sdc
sudo vgcreate slow-vg /dev/sdc
sudo lvcreate -l 100%FREE -n slow-lv slow-vg
sudo mkfs.ext4 /dev/slow-vg/slow-lv
sudo mkdir -p /mnt/log/slow
echo '/dev/slow-vg/slow-lv /mnt/log/slow ext4 defaults 0 2' | sudo tee -a /etc/fstab
sudo mount /mnt/log/slow
```

Confirm:
```bash
lsblk
df -h | grep /mnt/log
sudo lvs
```

# add ansible account, add keys, disable passwword login, allow sudo without password

```bash
sudo adduser --disabled-password --gecos "" ansible
sudo usermod -aG sudo ansible
sudo mkdir -p /home/ansible/.ssh
sudo chown ansible:ansible /home/ansible/.ssh
sudo chmod 700 /home/ansible/.ssh
echo 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIDheyyD3YcdX9nEY86UsTJyECxXnqOdoUc2jumPKFBvZ root@ansible
' | sudo tee /home/ansible/.ssh/authorized_keys
sudo chown ansible:ansible /home/ansible/.ssh/authorized_keys
sudo chmod 600 /home/ansible/.ssh/authorized_keys
sudo passwd -l ansible
echo 'ansible ALL=(ALL) NOPASSWD: ALL' | sudo tee /etc/sudoers.d/ansible
sudo chmod 440 /etc/sudoers.d/ansible
```
# allow root og add keys (kun poensearch)
Fordi opensearch kræver root for ansible deployment.

```bash
sudo mkdir -p /root/.ssh
sudo chmod 700 /root/.ssh
echo 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIDheyyD3YcdX9nEY86UsTJyECxXnqOdoUc2jumPKFBvZ root@ansible' | sudo tee /root/.ssh/authorized_keys
sudo chmod 600 /root/.ssh/authorized_keys
sudo sed -i 's/^#\?PermitRootLogin.*/PermitRootLogin prohibit-password/' /etc/ssh/sshd_config
sudo systemctl restart ssh
```


# REST IS DONE WITH ANSIBLE <3