# Account
Run this on the server end server to add ansible user with outpassword, ssh key only.
```sh
sudo adduser --disabled-password --gecos "" ansible
sudo usermod -aG sudo ansible
sudo mkdir -p /home/ansible/.ssh
sudo chown ansible:ansible /home/ansible/.ssh
sudo chmod 700 /home/ansible/.ssh
echo '<ssh-key>
' | sudo tee /home/ansible/.ssh/authorized_keys
sudo chown ansible:ansible /home/ansible/.ssh/authorized_keys
sudo chmod 600 /home/ansible/.ssh/authorized_keys
sudo passwd -l ansible
echo 'ansible ALL=(ALL) NOPASSWD: ALL' | sudo tee /etc/sudoers.d/ansible
sudo chmod 440 /etc/sudoers.d/ansible
```

# Deploy runbook
Run the following runbook with e.g.
```sh
ansible-playbook -i hosts.ini default-installation.yml
```

# hosts.ini
```yaml
root@ansible:~/ansible# cat hosts.ini 
[logservers]
log1.h0me.dk ansible_user=ansible
log2.h0me.dk ansible_user=ansible
log3.h0me.dk ansible_user=ansible
log4.h0me.dk ansible_user=ansible
log5.h0me.dk ansible_user=ansible
log6.h0me.dk ansible_user=ansible
``` 

# Default ansible runbook:
Just an example of simple runbook.
Requires .zshrc file

```yaml
root@ansible:~/ansible# cat default-installation.yml 
- name: Install default stuff
  hosts: logservers,otherservers
  become: true
  tasks:
    - name: Update APT package cache
      apt:
        update_cache: yes
        cache_valid_time: 3600  # Only re-check if cache is older than 1 hour

    - name: Upgrade all packages
      apt:
        upgrade: dist

    - name: Autoremove unused packages
      apt:
        autoremove: yes

    - name: Install apps with apt
      apt:
        name:
          - ipcalc
          - zsh
          - fortune
          - cowsay
          - chroma
          - python3-pygments
          - tmux
          - qemu-guest-agent
#          - default-jdk

        state: present
        update_cache: true

    - name: Set zsh as default shell for rasmus
      user:
        name: rasmus
        shell: /usr/bin/zsh

    - name: Install oh-my-zsh for rasmus (root install method)
      shell: |
        curl -fsSL https://raw.githubusercontent.com/ohmyzsh/ohmyzsh/master/tools/install.sh | bash -s -- --unattended
      args:
        chdir: /home/rasmus
        executable: /bin/bash
        creates: /home/rasmus/.oh-my-zsh
      environment:
        HOME: /home/rasmus

    - name: Fix ownership of oh-my-zsh files for rasmus
      file:
        path: /home/rasmus/.oh-my-zsh
        state: directory
        recurse: true
        owner: rasmus
        group: rasmus

    - name: Copy custom .zshrc to rasmus' home
      copy:
        src: files/zshrc
        dest: /home/rasmus/.zshrc
        owner: rasmus
        group: rasmus
        mode: '0644'

    - name: Ensure .ssh directory exists for rasmus
      file:
        path: /home/rasmus/.ssh
        state: directory
        owner: rasmus
        group: rasmus
        mode: '0700'

    - name: Add SSH keys from laptop and workstation to rasmus' authorized_keys
      authorized_key:
        user: rasmus
```